﻿/**
* Fuse Kit 2
* Copyright (c) 2006 Moses Gunesch, MosesSupposes.com
* 
* This class must be registered to pass easing Arrays generated by the Custom Easing Tool.
* <br>
* @usage
* The updated Custom Easing Tool differs slightly from its first appearance in lmc_tween - it now generates a simple Array that can be used 
* an easing parameter.
* <br><br>
* To create and use custom easing you now follow two steps:
* <ol><li>Pass the <code>CustomEasing</code> class to {@link com.mosesSupposes.fuse.ZigoEngine#register} or {@link com.mosesSupposes.fuse.ZigoEngine#simpleSetup} during setup.</li>
* <li>Use the Custom Easing Tool to generate a named Array, then pass it to any easing parameter in ZigoEngine or Fuse.<br>
* <br>For example if the panel outputs <code>var customEasing:Array = [...];</code>, you can then use <code>customEasing</code> in place of <code>"easeInOutQuad"</code> or other easing string/function, 
* and you can of course rename the variable as needed.</li>
* </ol>
* 
* @author	Easing by Ladislav Zigo
* @version	2.1.3
*/

class com.mosesSupposes.fuse.CustomEasing {

	/**
	 * @exclude
	 * Unique identifier used by ZigoEngine.register
	 */ 
	static var registryKey:String = 'customEasing';
	
	/**
	* Returns the nearest match in an Array of precaculated values, by percent of duration completed.
	* @param t		time
	* @param b		beginning position
	* @param c		total change in position
	* @param d		duration of the tween
	* @param pl		Array of precalculated values
	* @return		position
	*/
	static function precalced (t:Number,b:Number,c:Number,d:Number,pl:Array):Number {
		return b+c*pl[Math.round(t/d * pl.length)];
	}
	
	/**
	* Generates custom easing from an array of curve points exported by the Custom Easing Tool.
	* @param t		time
	* @param b		beginning position
	* @param c		total change in position
	* @param d		duration of the tween
	* @param pl		Array of precalculated values
	* @return		position
	*/
	static function fromCurve (t:Number,b:Number,c:Number,d:Number,pl:Array):Number {
		var r:Number = 200 * t/d;
		var i:Number = -1;
		var e:Object;
		while (pl[++i].Mx<=r) e = pl[i];
		var Px:Number = e.Px;
		var Nx:Number = e.Nx;
		var s:Number = (Px==0) ? -(e.Mx-r)/Nx : (-Nx+Math.sqrt(Nx*Nx-4*Px*(e.Mx-r)))/(2*Px);
		return (b-c*((e.My+e.Ny*s+e.Py*s*s)/200));
	}
}